/* ---------------------------------------------------------------------------
    2016 HID Global Corporation/ASSA ABLOY AB.  All rights reserved.

   Redistribution and use in source and binary forms, with or without modification,
   are permitted provided that the following conditions are met:
      - Redistributions of source code must retain the above copyright notice,
        this list of conditions and the following disclaimer.
      - Redistributions in binary form must reproduce the above copyright notice,
        this list of conditions and the following disclaimer in the documentation
        and/or other materials provided with the distribution.
        THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
        AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
        THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
        ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
        FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
        (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
        LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
        ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
        (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
        THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 --------------------------------------------------------------------------- */

#ifndef __SCENARIOS_H__
#define __SCENARIOS_H__

/* Functions */
void DataSignatureScenario(void);
void LoginScenario(void);
void SecretKeyUsageScenario(void);
void OTPGenerationScenario(void);

CK_RV Preamble(CK_SLOT_ID* SlotID);

CK_RV OpenSession(CK_SLOT_ID SlotID, BOOL bReadWrite, CK_SESSION_HANDLE *phSession);
CK_RV ListCertificates(CK_SESSION_HANDLE hSession, CK_OBJECT_HANDLE **pphObjectCert, int *pnbObjectCert);
CK_RV GetCertificateID(CK_SESSION_HANDLE hSession, CK_OBJECT_HANDLE hObjectCert, CK_BYTE_PTR *ppCertId, CK_ULONG *pCertIdLen);
CK_RV Login(CK_OBJECT_HANDLE hSession, BOOL bContextSpecific);
CK_RV FindPrivateKey(CK_OBJECT_HANDLE hSession, CK_BYTE_PTR pCertId, CK_ULONG ulCertIdLen, CK_OBJECT_HANDLE *phPrivateKey);
CK_RV Signdata(CK_OBJECT_HANDLE hSession, CK_OBJECT_HANDLE hPrivateKey, CK_BYTE pData[], CK_ULONG ulDataLen, CK_BYTE **ppDataSigned, CK_ULONG *pulDataSignedlen);
CK_RV FindPublicKey(CK_OBJECT_HANDLE hSession, CK_BYTE_PTR pCertId, CK_ULONG ulCertIdLen, CK_OBJECT_HANDLE *phPublicKey);
CK_RV VerifySignature(CK_OBJECT_HANDLE hSession, CK_OBJECT_HANDLE hPublicKey, CK_BYTE pData[], CK_ULONG ulDataLen, CK_BYTE *pDataSigned, CK_ULONG ulDataSignedlen);

CK_RV CanCardBeUnblocked(CK_SESSION_HANDLE hSession, CK_OBJECT_HANDLE * phObject, CK_BBOOL *pbUnblocked);
CK_RV GetUnblockCode(CK_SESSION_HANDLE hSession, CK_OBJECT_HANDLE hObject, CK_BYTE **ppusUnlock, CK_ULONG *pnUnlock, CK_MECHANISM *pMechanism);
CK_RV UnblockCard(CK_SESSION_HANDLE hSession, CK_MECHANISM Mechanism, CK_OBJECT_HANDLE hObject, CK_BYTE* pusUnlock, CK_ULONG nUnlock);
CK_RV ChangePIN(CK_SESSION_HANDLE hSession);

CK_RV FindSecretKey(CK_OBJECT_HANDLE hSession, CK_UTF8CHAR *pLabel, CK_ULONG ulLabelLen, CK_OBJECT_HANDLE *phSecretKey);
CK_RV Encrypt(CK_OBJECT_HANDLE hSession, CK_OBJECT_HANDLE hSecretKey, CK_BYTE pData[], CK_ULONG ulDataLen, CK_BYTE **ppDataEncrypted, CK_ULONG *pulDataEncryptedLen);
CK_RV Decrypt(CK_OBJECT_HANDLE hSession, CK_OBJECT_HANDLE hSecretKey, CK_BYTE pDataEncrypted[], CK_ULONG ulDataEncryptedLen, CK_BYTE **ppDataDecrypted, CK_ULONG *pulDataDecryptedLen);

CK_RV FindOTPKey(CK_OBJECT_HANDLE hSession, CK_OBJECT_HANDLE *phOTP);
CK_RV GetOTP(CK_OBJECT_HANDLE hSession, CK_OBJECT_HANDLE hOTPKey, CK_BYTE **ppDataOTP, CK_ULONG *pulDataOTPLen);

CK_RV Postamble(CK_SESSION_HANDLE hSession, BOOL LogoutToDo);

#endif // __SCENARIOS_H__
